// Type definitions for babel-types 7.0
// Project: https://github.com/babel/babel/tree/master/packages/babel-types, https://babeljs.io
// Definitions by: Troy Gerwien <https://github.com/yortus>
//                 Sam Baxter <https://github.com/baxtersa>
//                 Marvin Hagemeister <https://github.com/marvinhagemeister>
//                 Boris Cherny <https://github.com/bcherny>
//                 ExE Boss <https://github.com/ExE-Boss>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

export * from './ts3.6/index';

export function assertArrayExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ArrayExpression;
export function assertAssignmentExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').AssignmentExpression;
export function assertBinaryExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BinaryExpression;
export function assertDirective(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Directive;
export function assertDirectiveLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DirectiveLiteral;
export function assertBlockStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BlockStatement;
export function assertBreakStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BreakStatement;
export function assertCallExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').CallExpression;
export function assertCatchClause(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').CatchClause;
export function assertConditionalExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ConditionalExpression;
export function assertContinueStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ContinueStatement;
export function assertDebuggerStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DebuggerStatement;
export function assertDoWhileStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DoWhileStatement;
export function assertEmptyStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').EmptyStatement;
export function assertExpressionStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExpressionStatement;
export function assertFile(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').File;
export function assertForInStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ForInStatement;
export function assertForStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ForStatement;
export function assertFunctionDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').FunctionDeclaration;
export function assertFunctionExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').FunctionExpression;
export function assertIdentifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Identifier;
export function assertIfStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').IfStatement;
export function assertLabeledStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').LabeledStatement;
export function assertStringLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').StringLiteral;
export function assertNumericLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NumericLiteral;

/** @deprecated Use `assertNumericLiteral` */
export function assertNumberLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NumericLiteral;
export function assertNullLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NullLiteral;
export function assertBooleanLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BooleanLiteral;
export function assertRegExpLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').RegExpLiteral;

/** @deprecated Use `assertRegExpLiteral` */
export function assertRegexLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').RegExpLiteral;
export function assertLogicalExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').LogicalExpression;
export function assertMemberExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').MemberExpression;
export function assertNewExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NewExpression;
export function assertProgram(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Program;
export function assertObjectExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectExpression;
export function assertObjectMethod(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectMethod;
export function assertObjectProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectProperty;
export function assertRestElement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').RestElement;
export function assertReturnStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ReturnStatement;
export function assertSequenceExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').SequenceExpression;
export function assertSwitchCase(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').SwitchCase;
export function assertSwitchStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').SwitchStatement;
export function assertThisExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ThisExpression;
export function assertThrowStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ThrowStatement;
export function assertTryStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TryStatement;
export function assertUnaryExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').UnaryExpression;
export function assertUpdateExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').UpdateExpression;
export function assertVariableDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').VariableDeclaration;
export function assertVariableDeclarator(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').VariableDeclarator;
export function assertWhileStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').WhileStatement;
export function assertWithStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').WithStatement;
export function assertAssignmentPattern(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').AssignmentPattern;
export function assertArrayPattern(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ArrayPattern;
export function assertArrowFunctionExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ArrowFunctionExpression;
export function assertClassBody(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ClassBody;
export function assertClassDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ClassDeclaration;
export function assertClassExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ClassExpression;
export function assertExportAllDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExportAllDeclaration;
export function assertExportDefaultDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExportDefaultDeclaration;
export function assertExportNamedDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExportNamedDeclaration;
export function assertExportSpecifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExportSpecifier;
export function assertForOfStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ForOfStatement;
export function assertImportDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ImportDeclaration;
export function assertImportDefaultSpecifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ImportDefaultSpecifier;
export function assertImportNamespaceSpecifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ImportNamespaceSpecifier;
export function assertImportSpecifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ImportSpecifier;
export function assertMetaProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').MetaProperty;
export function assertClassMethod(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ClassMethod;
export function assertObjectPattern(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectPattern;
export function assertSpreadElement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').SpreadElement;
export function assertSuper(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Super;
export function assertTaggedTemplateExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TaggedTemplateExpression;
export function assertTemplateElement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TemplateElement;
export function assertTemplateLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TemplateLiteral;
export function assertYieldExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').YieldExpression;
export function assertAnyTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').AnyTypeAnnotation;
export function assertArrayTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ArrayTypeAnnotation;
export function assertBooleanTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BooleanTypeAnnotation;
export function assertBooleanLiteralTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BooleanLiteralTypeAnnotation;
export function assertNullLiteralTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NullLiteralTypeAnnotation;
export function assertClassImplements(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ClassImplements;
export function assertClassProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ClassProperty;
export function assertDeclareClass(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DeclareClass;
export function assertDeclareFunction(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DeclareFunction;
export function assertDeclareInterface(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DeclareInterface;
export function assertDeclareModule(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DeclareModule;
export function assertDeclareTypeAlias(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DeclareTypeAlias;
export function assertDeclareVariable(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DeclareVariable;
export function assertExistentialTypeParam(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExistentialTypeParam;
export function assertFunctionTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').FunctionTypeAnnotation;
export function assertFunctionTypeParam(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').FunctionTypeParam;
export function assertGenericTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').GenericTypeAnnotation;
export function assertInterfaceExtends(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').InterfaceExtends;
export function assertInterfaceDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').InterfaceDeclaration;
export function assertIntersectionTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').IntersectionTypeAnnotation;
export function assertMixedTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').MixedTypeAnnotation;
export function assertNullableTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NullableTypeAnnotation;
export function assertNumericLiteralTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NumericLiteralTypeAnnotation;
export function assertNumberTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').NumberTypeAnnotation;
export function assertStringLiteralTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').StringLiteralTypeAnnotation;
export function assertStringTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').StringTypeAnnotation;
export function assertThisTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ThisTypeAnnotation;
export function assertTupleTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TupleTypeAnnotation;
export function assertTypeofTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TypeofTypeAnnotation;
export function assertTypeAlias(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TypeAlias;
export function assertTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TypeAnnotation;
export function assertTypeCastExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TypeCastExpression;
export function assertTypeParameter(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TypeParameter;
export function assertTypeParameterDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TypeParameterDeclaration;
export function assertTypeParameterInstantiation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TypeParameterInstantiation;
export function assertObjectTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectTypeAnnotation;
export function assertObjectTypeCallProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectTypeCallProperty;
export function assertObjectTypeIndexer(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectTypeIndexer;
export function assertObjectTypeProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectTypeProperty;
export function assertQualifiedTypeIdentifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').QualifiedTypeIdentifier;
export function assertUnionTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').UnionTypeAnnotation;
export function assertVoidTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').VoidTypeAnnotation;
export function assertJSXAttribute(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXAttribute;
export function assertJSXClosingElement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXClosingElement;
export function assertJSXElement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXElement;
export function assertJSXEmptyExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXEmptyExpression;
export function assertJSXExpressionContainer(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXExpressionContainer;
export function assertJSXIdentifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXIdentifier;
export function assertJSXMemberExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXMemberExpression;
export function assertJSXNamespacedName(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXNamespacedName;
export function assertJSXOpeningElement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXOpeningElement;
export function assertJSXSpreadAttribute(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXSpreadAttribute;
export function assertJSXText(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSXText;
export function assertNoop(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Noop;
export function assertParenthesizedExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ParenthesizedExpression;
export function assertAwaitExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').AwaitExpression;
export function assertBindExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BindExpression;
export function assertDecorator(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Decorator;
export function assertDoExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').DoExpression;
export function assertExportDefaultSpecifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExportDefaultSpecifier;
export function assertExportNamespaceSpecifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExportNamespaceSpecifier;
export function assertRestProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').RestProperty;
export function assertSpreadProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').SpreadProperty;
export function assertExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Expression;
export function assertBinary(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Binary;
export function assertScopable(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Scopable;
export function assertBlockParent(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').BlockParent;
export function assertBlock(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Block;
export function assertStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Statement;
export function assertTerminatorless(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Terminatorless;
export function assertCompletionStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').CompletionStatement;
export function assertConditional(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Conditional;
export function assertLoop(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Loop;
export function assertWhile(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').While;
export function assertExpressionWrapper(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExpressionWrapper;
export function assertFor(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').For;
export function assertForXStatement(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ForXStatement;

export function assertFunction(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Function;
export function assertFunctionParent(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').FunctionParent;
export function assertPureish(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Pureish;
export function assertDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Declaration;
export function assertLVal(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').LVal;
export function assertLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Literal;
export function assertImmutable(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Immutable;
export function assertUserWhitespacable(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').UserWhitespacable;
export function assertMethod(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Method;
export function assertObjectMember(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ObjectMember;
export function assertProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Property;
export function assertUnaryLike(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').UnaryLike;
export function assertPattern(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Pattern;
export function assertClass(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Class;
export function assertModuleDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ModuleDeclaration;
export function assertExportDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ExportDeclaration;
export function assertModuleSpecifier(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').ModuleSpecifier;
export function assertFlow(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').Flow;
export function assertFlowBaseAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').FlowBaseAnnotation;
export function assertFlowDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').FlowDeclaration;
export function assertJSX(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').JSX;

export function assertTSAnyKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSAnyKeyword;
export function assertTSArrayType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSArrayType;
export function assertTSAsExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSAsExpression;
export function assertTSBooleanKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSBooleanKeyword;
export function assertTSCallSignatureDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSCallSignatureDeclaration;
export function assertTSConstructSignatureDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSConstructSignatureDeclaration;
export function assertTSConstructorType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSConstructorType;
export function assertTSDeclareFunction(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSDeclareFunction;
export function assertTSDeclareMethod(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSDeclareMethod;
export function assertTSEnumDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSEnumDeclaration;
export function assertTSEnumMember(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSEnumMember;
export function assertTSExportAssignment(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSExportAssignment;
export function assertTSExpressionWithTypeArguments(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSExpressionWithTypeArguments;
export function assertTSExternalModuleReference(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSExternalModuleReference;
export function assertTSFunctionType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSFunctionType;
export function assertTSImportEqualsDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSImportEqualsDeclaration;
export function assertTSIndexSignature(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSIndexSignature;
export function assertTSIndexedAccessType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSIndexedAccessType;
export function assertTSInterfaceBody(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSInterfaceBody;
export function assertTSInterfaceDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSInterfaceDeclaration;
export function assertTSIntersectionType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSIntersectionType;
export function assertTSLiteralType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSLiteralType;
export function assertTSMappedType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSMappedType;
export function assertTSMethodSignature(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSMethodSignature;
export function assertTSModuleBlock(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSModuleBlock;
export function assertTSModuleDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSModuleDeclaration;
export function assertTSNamespaceExportDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSNamespaceExportDeclaration;
export function assertTSNeverKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSNeverKeyword;
export function assertTSNonNullExpression(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSNonNullExpression;
export function assertTSNullKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSNullKeyword;
export function assertTSNumberKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSNumberKeyword;
export function assertTSObjectKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSObjectKeyword;
export function assertTSParameterProperty(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSParameterProperty;
export function assertTSParenthesizedType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSParenthesizedType;
export function assertTSPropertySignature(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSPropertySignature;
export function assertTSQualifiedName(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSQualifiedName;
export function assertTSStringKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSStringKeyword;
export function assertTSSymbolKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSSymbolKeyword;
export function assertTSThisType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSThisType;
export function assertTSTupleType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTupleType;
export function assertTSTypeAliasDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeAliasDeclaration;
export function assertTSTypeAnnotation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeAnnotation;
export function assertTSTypeAssertion(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeAssertion;
export function assertTSTypeLiteral(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeLiteral;
export function assertTSTypeOperator(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeOperator;
export function assertTSTypeParameter(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeParameter;
export function assertTSTypeParameterDeclaration(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeParameterDeclaration;
export function assertTSTypeParameterInstantiation(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeParameterInstantiation;
export function assertTSTypePredicate(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypePredicate;
export function assertTSTypeQuery(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeQuery;
export function assertTSTypeReference(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSTypeReference;
export function assertTSUndefinedKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSUndefinedKeyword;
export function assertTSUnionType(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSUnionType;
export function assertTSVoidKeyword(node: object | null | undefined, opts?: object): asserts node is import('./ts3.6/index').TSVoidKeyword;
