<div>
  <div x-data="{level:1}">
    <h1 class="text-center font-bold lg:text-7xl md:text-5xl text-2xl my-4 mx-2 tracking-wide" x-show.transition.duration.500ms="level == 1"><span class="text-white">{{__('How you prefer')}}</span> <span class="text-yellow-custom">{{__('your meat cuts?')}}</span></h1>
    <div class="flex flex-col items-center justify-center px-2 gap-4" x-show.transition.duration.500ms="level == 1">
      @foreach ($bones as $key => $bone)
      <div class="lg:w-3/4 md:w-1/2 w-full">
        <div class="border-yellow-400 border-2 flex flex-row mb-2 rounded-md transition duration-500 ease-in-out transform hover:-translate-y-1 hover:shadow-lg" @click="level = 2" wire:click="$set('selectedBone','{{$key}}')">
          <div class="select-none cursor-pointer bg-transparent rounded-md flex flex-1 items-center p-4">
            <div class="flex-1 pl-1 mr-16">
              <div class="text-white text-center text-2xl">🥩 {{$bone}}</div>
            </div>
          </div>
        </div>
      </div>
      @endforeach 
    </div>
    <h1 class="text-center font-bold lg:text-7xl md:text-5xl text-2xl my-4 mx-2 tracking-wide" x-show.transition.duration.500ms="level == 2"><span class="text-white">{{__('How you like')}}</span> <span class="text-yellow-custom">{{__('your meat cuts?')}}</span></h1>
    <div class="flex flex-col items-center justify-center px-2 gap-4" x-show.transition.duration.500ms="level == 2">
      @foreach ($fats as $key => $fat)
      <div class="lg:w-3/4 md:w-1/2 w-full">
        <div class="border-yellow-400 border-2 flex flex-row mb-2 rounded-md transition duration-500 ease-in-out transform hover:-translate-y-1 hover:shadow-lg" @click="level = 3" wire:click="$set('selectedFat','{{$key}}')">
          <div class="select-none cursor-pointer bg-transparent rounded-md flex flex-1 items-center p-4">
            <div class="flex-1 pl-1 mr-16">
              <div class="text-white text-center text-2xl">🥩 {{$fat}}</div>
            </div>
          </div>
        </div>
      </div>
      @endforeach 
    </div>
    @if ($selectedBone == 1)
      <h1 class="text-center font-bold lg:text-7xl md:text-5xl text-2xl text-red-custom my-4 mx-2 tracking-wide" x-show.transition.duration.1000ms="level == 3"><span class="text-white">{{__('How thick do you prefer')}}</span> <span class="text-yellow-custom">{{__('your meat cuts?')}}</span></h1>
      <div class="flex flex-col items-center justify-center px-2 gap-4" x-show.transition.duration.1000ms="level == 3">
        @foreach ($thicknesses as $key =>  $thikness)
        <div class="lg:w-3/4 md:w-1/2 w-full">
          <div class="border-yellow-400 border-2 flex flex-row mb-2 rounded-md transition duration-500 ease-in-out transform hover:-translate-y-1 hover:shadow-lg" @click="level = 4" wire:click="$set('selectedStyle','{{$key}}')">
            <div class="select-none cursor-pointer bg-transparent rounded-md flex flex-1 items-center p-4 ">
              <div class="flex-1 pl-1 mr-16">
                <div class="text-white text-center text-2xl">🥩 {{$thikness}}</div>
              </div>
            </div>
          </div>
        </div>
        @endforeach 
      </div>        
    @endif

    @if ($selectedBone == 0)
      <h1 class="text-center font-bold lg:text-7xl md:text-5xl text-2xl my-4 mx-2 tracking-wide" x-show.transition.duration.1000ms="level == 3"><span class="text-white">{{__('What style do you prefer')}}</span> <span class="text-yellow-custom">{{__('your meat cuts?')}}</span></h1>
      <div class="flex flex-col items-center justify-center px-2 gap-4" x-show.transition.duration.1000ms="level == 3">
        @foreach ($styles as $key =>  $style)
        <div class="lg:w-3/4 md:w-1/2 w-full">
          <div class="border-yellow-400 border-2 flex flex-row mb-2 rounded-md transition duration-500 ease-in-out transform hover:-translate-y-1 hover:shadow-lg" @click="level = 4" wire:click="$set('selectedStyle','{{$key}}')">
            <div class="select-none cursor-pointer bg-transparent rounded-md flex flex-1 items-center p-4 ">
              <div class="flex-1 pl-1 mr-16">
                <div class="text-white text-center text-2xl">🥩 {{$style}}</div>
              </div>
            </div>
          </div>
        </div>
        @endforeach 
      </div>        
    @endif
    @if ($selectedStyle != '')
      <h1 class="text-center font-bold lg:text-7xl md:text-5xl text-2xl my-4 mx-2 tracking-wide" x-show.transition.duration.1500ms="level == 4"><span class="text-white">{{__('We recommend you these')}}</span> <span class="text-yellow-custom">{{__('meat cuts')}}</span></h1>
      <div class="flex justify-center">
        <button wire:click="resetTest()" @click="level = 1" class="block tracking-tighter text-center text-yellow-400 shadow bg-transparent border-yellow-400 border-2 hover:bg-yellow-500 hover:text-white focus:shadow-outline focus:outline-none text-xl py-2 px-14 rounded">{{__('Try again')}}</button>
      </div>
      <div class="grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-4 px-2" x-show.transition.duration.1500ms="level == 4">
        @foreach ($meats[$selectedBone][$selectedFat][$selectedStyle] as $key =>  $meat)
        <div class="px-2" x-show-transition.duration.1500ms="level == 4">
          <div class="max-w-sm bg-black shadow-lg rounded-lg overflow-hidden my-4 transition duration-500 ease-in-out transform hover:-translate-y-1 hover:shadow-lg">
            <img class="w-full h-56 object-cover object-center" src="{{asset('img/'.$meat['img_path'])}}" alt="{{$meat['name']}}">
            <div class="py-4 px-6">
              <h1 class="text-2xl font-light text-center text-white uppercase">{{$meat['name']}}</h1>
              <p class="py-2 text-lg text-white"></p>
            </div>
            <div class="py-4 flex justify-center">
              <button wire:click="openModalMeat({{$key}})" class="block tracking-tighter text-center text-yellow-400 shadow bg-transparent border-yellow-400 border-2 hover:bg-yellow-500 hover:text-white focus:shadow-outline focus:outline-none text-xl py-2 px-14 rounded">{{__('See meat cut')}}</button>
            </div>
          </div>
        </div>
        @endforeach 
      </div>
      <div class="my-16 hidden">
        <h2 class="text-center font-bold lg:text-5xl md:text-3xl text-lg text-red-custom my-4 mx-2 tracking-wide">{{__('Your results')}}</h2>
        <div class="flex flex-row flex-wrap">
          <div class="flex-col lg:w-1/3 md:w-1/2 w-full">
            <p class="text-yellow-custom text-lg text-center">{{__('How I prefer meat cuts?')}}</p>
            <p class="text-white text-md text-center">{{$bones[$selectedBone]}}</p>
          </div>
          <div class="flex-col lg:w-1/3 md:w-1/2 w-full">            
            <p class="text-yellow-custom text-lg text-center">{{__('How I like meat cuts?')}}</p>
            <p class="text-white text-md text-center">{{$fats[$selectedFat]}}</p>
          </div>
          @if ($selectedBone == 1)
            <div class="flex-col lg:w-1/3 md:w-1/2 w-full">
              <p class="text-yellow-custom text-lg text-center">{{__('How thick I like meat cuts?')}}</p>
              <p class="text-white text-md text-center">{{$thicknesses[$selectedStyle]}}</p>
            </div>
          @endif
          @if ($selectedBone == 0)
            <div class="flex-col lg:w-1/3 md:w-1/2 w-full">
              <p class="text-yellow-custom text-lg text-center">{{__('What style do I prefer meat cuts?')}}</p>
              <p class="text-white text-md text-center">{{$styles[$selectedStyle]}}</p>
            </div>
          @endif
        </div>
      </div>
    @endif
  </div>
  <x-dialog-modal wire:model="meatModal">
    <x-slot name="title">

    </x-slot>
    <x-slot name="content">
      @if ($meatpic != '')
      <div class="flex justify-center">
        <img src="{{asset('img/'.$meatpic)}}" alt="">  
      </div>
      @endif
    </x-slot>
    <x-slot name="footer">

    </x-slot>
  </x-dialog-modal>
</div>
