<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'Carnes becerra')); ?></title>
    <link rel="icon" href="<?php echo e(asset('img/carnes_becerra_ico.png')); ?>">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.2/css/all.min.css" integrity="sha512-HK5fgLBL+xu6dm/Ii3z4xhlSUyZgTT9tuc/hSrtw6uzJOvgRr2a9jyxxT1ely+B+xFAmJKVSTbpM/CuL7qxO8w==" crossorigin="anonymous" />
    <link rel="stylesheet" href="<?php echo e(mix('css/app.css')); ?>">
    <?php echo \Livewire\Livewire::styles(); ?>

    <?php echo $__env->yieldContent('stylesheets'); ?>
    <script src="<?php echo e(mix('js/app.js')); ?>" defer></script>
  </head>
  <body class="font-sans antialiased" id="main-body">
    <div class="min-h-screen">
      <main>
        <?php echo e($slot); ?>

      </main>
    </div>
    <?php echo \Livewire\Livewire::scripts(); ?>

    <?php echo $__env->yieldContent('scripts'); ?>
  </body>
</html>
<?php /**PATH C:\laragon\www\carnes_becerra\resources\views/layouts/app.blade.php ENDPATH**/ ?>